import type { BrowserManager } from './types';

let browserManager: BrowserManager | null;

export const register = (manager: BrowserManager) => {
    browserManager = manager;
};

export const getBrowserManager = () => {
    if (!browserManager) {
        throw Error('Browser manager is not registered yet');
    }

    return browserManager;
};
