import { close } from '@client/lib/js-api';
import { prepareFields } from '@common/browser-manager/util';

import type { UserProfile } from '@src/types';
import type { BrowserManager } from './types';

const onClose = () => close();
const onAccepted = (data: UserProfile) => Promise.resolve(close(prepareFields(data)));

export const jsApiManager: BrowserManager = {
    onClose,
    onAccepted,
};
