import type { UserProfile, FieldError } from '@src/types';

type AcceptedOptions = {
    needValidate?: boolean;
};

export type ValidationErrors = Partial<Record<keyof UserProfile, FieldError | null>>;

type AcceptedResponse = void | { validationErrors: ValidationErrors } | { extendedError: string };

export type BrowserManager = {
    onAccepted: (data: UserProfile, options: AcceptedOptions) => Promise<AcceptedResponse>;
    onClose: () => void;
};
