import { entries } from '@client/util';
import type { UserProfile } from '@src/types';
import { formatPhone } from '@src/util';

const rightTrimRegexp = /[\s]+$/g;
const leftTrimRegexp = /^[\s]+/g;

const ltrim = (str: string) => {
    return str.replace(leftTrimRegexp, '');
};

const rtrim = (str: string) => {
    return str.replace(rightTrimRegexp, '');
};

const trim = (str: string) => {
    return ltrim(rtrim(str));
};

export const prepareFields = <K extends keyof UserProfile>(records: Partial<Record<K, string>>) => {
    return entries(records).reduce<Partial<Record<K, string>>>((acc, [key, value]) => {
        if (!value) {
            return acc;
        }

        value = trim(value);

        if (key === 'phone') {
            value = formatPhone(value) || value;
        }

        if (value) {
            acc[key] = value;
        }
        return acc;
    }, {});
};
