import React from 'react';
import { classNames } from '@common/util';

import styles from './action-button.css';

type BaseActionButtonProps = {
    dataT: string;
    type?: React.ButtonHTMLAttributes<HTMLButtonElement>['type'];
    className?: string;
    onClick?: () => void;
    disabled?: boolean;
};

export const BaseActionButton: React.FC<BaseActionButtonProps> = props => {
    const { dataT, children, className, onClick, disabled, type = 'button' } = props;

    return (
        <button
            type={type}
            data-t={dataT}
            disabled={disabled}
            className={classNames(styles['action-button'], className)}
            onClick={onClick}
        >
            {children}
        </button>
    );
};
