import React from 'react';
import { BaseActionButton } from '@common/components/ActionButtons/BaseActionButton';
import { classNames } from '@common/util';

import styles from './default-button.css';

type DefaultButtonProps = {
    dataT: string;
    className?: string;
    onClick?: () => void;
};

export const DefaultButton: React.FC<DefaultButtonProps> = ({ dataT, className, onClick, children }) => {
    return (
        <BaseActionButton dataT={dataT} className={classNames(styles['default-button'], className)} onClick={onClick}>
            {children}
        </BaseActionButton>
    );
};
