import React from 'react';
import { BaseActionButton } from '@common/components/ActionButtons/BaseActionButton';
import { classNames } from '@common/util';

import styles from './login-button.css';

type ButtonProps = {
    className?: string;
    onClick: () => void;
    dataT: string;
    disabled?: boolean;
};

export const LoginButton: React.FC<ButtonProps> = ({ className, onClick, dataT, children, disabled }) => {
    return (
        <BaseActionButton
            dataT={dataT}
            className={classNames(styles.button, className)}
            onClick={onClick}
            disabled={disabled}
        >
            {children}
        </BaseActionButton>
    );
};
