import React from 'react';
import { ScreenManager } from '@common/components/ScreenManager';
import { AppDataContext, AppDataContextValue } from '@common/data/AppDataContext';
import { ActiveProfileProvider } from '@common/data/ActiveProfileContext';
import { ActiveScreenProvider } from '@common/data/ActiveScreenContext';
import { Skeleton } from '@common/components/Skeleton';
import { useWaitData } from '@common/hooks/useWaitData';

import './App.css';
import './BroApp.css';

type AppProps = {
    initialData: AppDataContextValue;
};

export const BroApp: React.FC<AppProps> = ({ initialData }) => {
    const { isLoading, data } = useWaitData(initialData);

    return (
        <AppDataContext.Provider value={data}>
            {isLoading ? (
                <Skeleton />
            ) : (
                <ActiveScreenProvider>
                    <ActiveProfileProvider>
                        <ScreenManager />
                    </ActiveProfileProvider>
                </ActiveScreenProvider>
            )}
        </AppDataContext.Provider>
    );
};
