import React, { useContext } from 'react';
import { ActiveProfileContext } from '@common/data/ActiveProfileContext';
import { FillButton } from '@common/components/ActionButtons/FillButton';
import { CardHeader } from '@common/components/CardHeader';
import { ProfileList } from '@common/components/ProfileList';

import styles from './card.css';

export const Card: React.FC = () => {
    const { index } = useContext(ActiveProfileContext);

    return (
        <div data-t="card" className={styles.card}>
            <CardHeader />
            <ProfileList />
            <FillButton needValidate={false} disabled={index === -1} />
        </div>
    );
};
