import React, { useContext } from 'react';
import { AppDataContext } from '@common/data/AppDataContext';
import { CloseButton } from '@common/components/ControlButtons/Close';

import styles from './card-header.css';

export const CardHeader: React.FC = () => {
    const { locals } = useContext(AppDataContext);

    return (
        <div className={styles['card-header']}>
            <span>{locals.common['header.bro.title']}</span>
            <CloseButton dataT="close-button" className={styles.close} />
        </div>
    );
};
