import React from 'react';
import { classNames } from '@common/util';

import styles from './control-button.css';

export type BaseControlButtonProps = {
    dataT: string;
    className?: string;
    onClick?: React.MouseEventHandler;
};

export const BaseControlButton: React.FC<BaseControlButtonProps> = ({ dataT, className, onClick }) => {
    return (
        <button
            type="button"
            data-t={dataT}
            className={classNames(styles['control-button'], className)}
            onClick={onClick}
        />
    );
};
