import React, { useCallback } from 'react';
import { getBrowserManager } from '@common/browser-manager';
import { metrika } from '@common/metrika';
import { classNames } from '@common/util';

import { BaseControlButton, BaseControlButtonProps } from '../BaseControlButton';

import styles from './close.css';

export const CloseButton: React.FC<BaseControlButtonProps> = ({ className }) => {
    const onClick = useCallback(() => {
        metrika.params({
            close: 'click',
        });
        getBrowserManager().onClose();
    }, []);

    return <BaseControlButton dataT="close-button" className={classNames(styles.close, className)} onClick={onClick} />;
};
