import React, { useCallback } from 'react';
import { FormExtendedError } from '@common/components/FormExtendedError';
import { ErrorsProvider } from '@common/components/Form/ErrorsContext';
import { FormHeader } from '@common/components/FormHeader';
import { FormContent } from '@common/components/FormContent';
import { FillButton } from '@common/components/ActionButtons/FillButton';

import styles from './form.css';

export const Form: React.FC = () => {
    const onSubmit = useCallback((e: React.FormEvent) => {
        e.preventDefault();
    }, []);

    return (
        <ErrorsProvider>
            <form data-t="extended-form" className={styles.form} onSubmit={onSubmit}>
                <FormHeader />
                <FormContent />
                <FillButton needValidate />
                <FormExtendedError className={styles.error} />
            </form>
        </ErrorsProvider>
    );
};
