import React, { useContext, useMemo } from 'react';
import { AppDataContext } from '@common/data/AppDataContext';
import { FormUserName } from '@common/components/FormUserName';
import { FormPhoneSelect } from '@common/components/FormSelect/FormPhoneSelect';
import { FormEmailSelect } from '@common/components/FormSelect/FormEmailSelect';
import { FormAddressSelect } from '@common/components/FormSelect/FormAddressSelect';
import { includesInArray } from '@common/util';

import styles from './form-content.css';

export const FormContent: React.FC = () => {
    const {
        meta: { whitelist },
    } = useContext(AppDataContext);

    const needUserName = useMemo(() => {
        return includesInArray(whitelist, 'firstName') && includesInArray(whitelist, 'lastName');
    }, [whitelist]);
    const needPhone = useMemo(() => includesInArray(whitelist, 'phone'), [whitelist]);
    const needEmail = useMemo(() => includesInArray(whitelist, 'email'), [whitelist]);
    const needAddress = useMemo(() => includesInArray(whitelist, 'address'), [whitelist]);

    return (
        <div className={styles['form-content']}>
            {needUserName && <FormUserName />}
            {needPhone && <FormPhoneSelect />}
            {needEmail && <FormEmailSelect />}
            {needAddress && <FormAddressSelect />}
        </div>
    );
};
