import { AppDataContext } from '@common/data/AppDataContext';
import { classNames } from '@common/util';
import React, { useContext, useEffect } from 'react';
import { ErrorContext } from '@common/components/Form/ErrorsContext';

import styles from './form-extended-error.css';

type FormExtendedErrorProps = {
    className?: string;
};

const ERROR_SHOW_MS = 5000;

export const FormExtendedError: React.FC<FormExtendedErrorProps> = ({ className }) => {
    const { common } = useContext(AppDataContext).locals;
    const { internalError, clearInternalError } = useContext(ErrorContext);

    useEffect(() => {
        if (!internalError) {
            return;
        }

        const timerId = window.setTimeout(() => clearInternalError(), ERROR_SHOW_MS);

        return () => window.clearTimeout(timerId);
    }, [internalError, clearInternalError]);

    if (!internalError) {
        return null;
    }

    return (
        <div data-t="extended-error" className={classNames(className, styles.error)}>
            {internalError}.&nbsp;{common['try-again']}
        </div>
    );
};
