import React, { useContext, useCallback } from 'react';
import { AppDataContext } from '@common/data/AppDataContext';
import { ActiveProfileContext } from '@common/data/ActiveProfileContext';
import { ActiveScreenContext } from '@common/data/ActiveScreenContext';
import { CloseButton } from '@common/components/ControlButtons/Close';
import { TRANSITION_ANIMATION_DURATION_MS } from '@src/constants';

import styles from './form-header.css';

export const FormHeader: React.FC = () => {
    const { index, updateProfile, setIndex } = useContext(ActiveProfileContext);
    const { setScreen } = useContext(ActiveScreenContext);
    const {
        profiles,
        locals: { extended },
    } = useContext(AppDataContext);

    const onButtonClick = useCallback(() => {
        // Если в текущий момент не выбран никакой профиль из списка, выбираем первый
        const activeProfileIndex = index === -1 && profiles.length ? 0 : index;

        setIndex(activeProfileIndex);
        // Сбрасываем все изменения в форме, при переходе к списку профилей
        window.setTimeout(() => updateProfile(profiles[activeProfileIndex]), TRANSITION_ANIMATION_DURATION_MS);

        setScreen('card');
    }, [setScreen, index, setIndex, profiles, updateProfile]);

    return (
        <div className={styles['form-header']}>
            <button
                type="button"
                data-t="extended-form-back-button"
                className={styles['form-header-button']}
                onClick={onButtonClick}
            >
                {extended.header}
            </button>
            <CloseButton dataT="close-button" className={styles.close} />
        </div>
    );
};
