import React, { useState, useContext, useCallback } from 'react';
import { ErrorContext } from '@common/components/Form/ErrorsContext';
import { AppDataContext } from '@common/data/AppDataContext';
import { ActiveProfileContext } from '@common/data/ActiveProfileContext';
import { AddressSuggest } from '@common/components/AddressSuggest';
import { BaseFormSelect } from '../BaseFormSelect';

import type { SelectOption } from '@common/components/Select';

import styles from './address-select.css';

export const FormAddressSelect: React.FC = () => {
    const { clearValidationError } = useContext(ErrorContext);

    const {
        profile: { address },
        updateProfile,
    } = useContext(ActiveProfileContext);
    const {
        models,
        locals: { common, extended },
    } = useContext(AppDataContext);

    const [phoneOptions] = useState(() => {
        return models.addresses
            .map<SelectOption>(address => ({ value: address, label: address }))
            .concat({ value: extended['add.address'], label: extended['new.address'], isNew: true });
    });
    const [isNewValueFieldVisible, setNewValueFieldVisible] = useState(false);

    const onSelect = useCallback(
        ({ isNew, value }: SelectOption) => {
            updateProfile({ address: isNew ? '' : value });
            setNewValueFieldVisible(Boolean(isNew));

            if (!isNew) {
                clearValidationError('address');
            }
        },
        [updateProfile, clearValidationError],
    );

    return (
        <>
            <BaseFormSelect
                label={common.address}
                dataT="extended-address"
                activeProfileOption={address ?? ''}
                initialOptions={phoneOptions}
                onSelect={onSelect}
            />
            {isNewValueFieldVisible && <AddressSuggest className={styles['new-address']} />}
        </>
    );
};
