import React from 'react';
import { ScreenManager } from '@common/components/ScreenManager';
import { AppDataContext, AppDataContextValue } from '@common/data/AppDataContext';
import { ActiveProfileProvider } from '@common/data/ActiveProfileContext';
import { ActiveScreenProvider } from '@common/data/ActiveScreenContext';

import './App.css';

type AppProps = {
    initialData: AppDataContextValue;
};

export const IframeApp: React.FC<AppProps> = ({ initialData }) => {
    return (
        <AppDataContext.Provider value={initialData}>
            <ActiveScreenProvider>
                <ActiveProfileProvider>
                    <ScreenManager />
                </ActiveProfileProvider>
            </ActiveScreenProvider>
        </AppDataContext.Provider>
    );
};
