import { getButtonView, getButtonTheme, calcCanShowLongText, setStyle } from './utils';
import { SuggestButtonOptions, Constants } from '@src/types';
import { classNames } from '@common/util';
import locs from '@src/locs';

const WINDOW_WIDTH = 640;
const WINDOW_HEIGHT = 720;

interface PersonalButtonStub {
    targetOrigin?: string;
    parentId?: string;
    suggestButtonOptions: SuggestButtonOptions;
    lang?: Constants['lang'];
}

export const personalButtonStub = ({ targetOrigin = 'https://autofill.yandex.ru', parentId = '', suggestButtonOptions = {}, lang = 'ru' }: PersonalButtonStub) => {
    setStyle();
    const button: HTMLButtonElement = document.createElement('button');
    const avatar: HTMLDivElement = document.createElement('div');
    const parentElement = document.getElementById(parentId) || document.body;

    const {
        buttonSize: size = 'm',
        buttonView: view = 'main',
        buttonTheme: theme = 'light',
        buttonBorderRadius: borderRadius = '0',
    } = suggestButtonOptions;

    const buttonLocs = {
        ru: {
            short: locs.ru.suggest['button.signin.short'],
            long: locs.ru.suggest['button.signin.default'],
        },
        en: {
            short: locs.en.suggest['button.signin.short'],
            long: locs.en.suggest['button.signin.default'],
        },
    };

    const buttonLoc = buttonLocs[lang] || buttonLocs.ru;
    const shortText = buttonLoc.short;
    const longText = buttonLoc.long;
    const buttonText = calcCanShowLongText(size, parentElement.clientWidth) ? longText : shortText;
    const currentView = getButtonView(view);
    const currentTheme = getButtonTheme(theme);

    button.id = 'yaPersonalButton';
    button.type = 'button';
    button.className = classNames(
        'yaPersonalButton',
        `yaPersonalButton_${size}`,
        `yaPersonalButton_${currentView}`,
        `yaPersonalButton_${currentTheme}`,
    );
    button.style.borderRadius = `${borderRadius}px`;
    avatar.className = 'yaPersonalButtonAvatar';
    avatar.style.backgroundImage = 'url("https://avatars.mds.yandex.net/get-yapic/0/0-0/islands-50")';
    button.insertAdjacentHTML('afterbegin', `
        <div class="yaPersonalButtonLogo"></div>
        <div class="yaPersonalButtonInfo">
            <div class="yaPersonalButtonText">
                ${buttonText}
            </div>
        </div>
    `);
    button.appendChild(avatar);

    const popupUrl = `${targetOrigin}/suggest/popup${document.location.search}`;

    const onLogInClick = () => {
        window.popupWindow = window.open(
            popupUrl,
            'oauth',
            `left=${(screen.width - WINDOW_WIDTH) / 2}, top=${
                (screen.height - WINDOW_HEIGHT) / 2
            }, width=${WINDOW_WIDTH}, height=${WINDOW_HEIGHT}, scrollbars=no`,
        );
    };

    button.addEventListener('click', onLogInClick);

    parentElement.appendChild(button);
};
