export const buttonStyle = `
    @font-face {
        font-family: 'YS Text';
        src: url('//yastatic.net/s3/home/fonts/ys/1/text-regular.woff2') format('woff2'), url('//yastatic.net/s3/home/fonts/ys/1/text-regular.woff') format('woff');
        font-weight: normal;
        font-style: normal;
        font-stretch: normal;
    }
    @font-face {
        font-family: 'YS Text';
        src: url('//yastatic.net/s3/home/fonts/ys/1/text-medium.woff2') format('woff2'), url('//yastatic.net/s3/home/fonts/ys/1/text-medium.woff') format('woff');
        font-weight: 500;
        font-style: normal;
        font-stretch: normal;
    }
    @font-face {
        font-family: 'YS Text';
        src: url('//yastatic.net/s3/home/fonts/ys/1/text-bold.woff2') format('woff2'), url('//yastatic.net/s3/home/fonts/ys/1/text-bold.woff') format('woff');
        font-weight: bold;
        font-style: normal;
        font-stretch: normal;
    }
    .yaPersonalButton {
        box-sizing: border-box;
        width: 100%;
        margin: 0;

        display: flex;
        justify-content: space-between;
        align-items: center;

        font-family: 'YS Text', 'Helvetica Neue', Arial, sans-serif;
        color: #fff;
        cursor: pointer;

        border: none;
        border-radius: 0;
        outline: 0;
        background-color: #000;
    }
    .yaPersonalButton_main.yaPersonalButton_light {
        border: none;
        background-color: #000;
        color: #fff
    }
    .yaPersonalButton_main.yaPersonalButton_dark {
        border: none;
        background-color: #fff;
        color: #000
    }
    .yaPersonalButton_additional.yaPersonalButton_light {
        border: 1px solid #000;
        background-color: #fff;
        color: #000
    }
    .yaPersonalButton_additional.yaPersonalButton_dark {
        border: 1px solid #fff;
        background-color: #000;
        color: #fff
    }
    .yaPersonalButton_xs {
        height: 36px;
        min-width: 150px;
        padding: 8px 10px;
        font-size: 14px;
        line-height: 18px;
    }
    .yaPersonalButton_xs .yaPersonalButtonLogo {
        width: 18px;
        height: 18px;
        margin-right: 14px;
    }
    .yaPersonalButton_xs .yaPersonalButtonAvatar {
        width: 20px;
        height: 20px;
        margin-left: 12px;
    }
    .yaPersonalButton_s {
        height: 40px;
        min-width: 156px;
        padding: 9px 11px;
        font-size: 14px;
        line-height: 18px;
    }
    .yaPersonalButton_s .yaPersonalButtonLogo {
        width: 20px;
        height: 20px;
        margin-right: 14px;
    }
    .yaPersonalButton_s .yaPersonalButtonAvatar {
        width: 22px;
        height: 22px;
        margin-left: 12px;
    }
    .yaPersonalButton_m {
        height: 44px;
        min-width: 170px;
        padding: 10px 12px;
        font-size: 16px;
        line-height: 20px;
    }
    .yaPersonalButton_m .yaPersonalButtonLogo {
        width: 22px;
        height: 22px;
        margin-right: 14px;
    }
    .yaPersonalButton_m .yaPersonalButtonAvatar {
        width: 24px;
        height: 24px;
        margin-left: 12px;
    }
    .yaPersonalButton_l {
        height: 48px;
        min-width: 176px;
        padding: 11px 13px;
        font-size: 16px;
        line-height: 20px;
    }
    .yaPersonalButton_l .yaPersonalButtonLogo {
        width: 24px;
        height: 24px;
        margin-right: 14px;
    }
    .yaPersonalButton_l .yaPersonalButtonAvatar {
        width: 26px;
        height: 26px;
        margin-left: 12px;
    }
    .yaPersonalButton_xl {
        height: 52px;
        min-width: 184px;
        padding: 13px 15px;
        padding: 14px;
        font-size: 16px;
        line-height: 20px;
    }
    .yaPersonalButton_xl .yaPersonalButtonLogo {
        width: 24px;
        height: 24px;
        margin-right: 16px;
    }
    .yaPersonalButton_xl .yaPersonalButtonAvatar {
        width: 26px;
        height: 26px;
        margin-left: 14px;
    }
    .yaPersonalButton_xxl {
        height: 56px;
        min-width: 194px;
        padding: 14px 16px;
        font-size: 16px;
        line-height: 20px;
    }
    .yaPersonalButton_xxl .yaPersonalButtonLogo {
        width: 26px;
        height: 26px;
        margin-right: 18px;
    }
    .yaPersonalButton_xxl .yaPersonalButtonAvatar {
        width: 28px;
        height: 28px;
        margin-left: 16px;
    }
    .yaPersonalButtonLogo {
        position: relative;

        flex-shrink: 0;
        margin-right: auto;

        border-radius: 50%;
        background-size: contain;
        background-image: url("data:image/svg+xml,%3Csvg width='20' height='20' viewBox='0 0 48 48' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Ccircle cx='24' cy='24' r='24' fill='%23fc3f1d'/%3E%3Cpath d='M27.2,13.6H25c-4.1,0-6.2,2.1-6.2,5.1c0,3.4,1.5,5,4.5,7.1l2.5,1.7l-7.2,10.8h-5.4l6.5-9.6c-3.7-2.7-5.8-5.3-5.8-9.6c0-5.5,3.8-9.2,11.1-9.2h7.2v28.5h-5V13.6z' fill='%23fff'/%3E%3C/svg%3E");
    }
    .yaPersonalButtonInfo {
        font-weight: 500;
        overflow: hidden;
    }
    .yaPersonalButtonText {
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }
    .yaPersonalButtonAvatar {
        position: relative;
        box-sizing: border-box;

        flex-shrink: 0;
        margin-left: auto;

        border-radius: 50%;
        border: 0.5px solid #767676;
        background-size: contain;
        background-color: #767676;
    }
    .yaPersonalButtonAvatar_plus {
        border: none;
    }
    .yaPersonalButtonAvatar_plus::before {
        content: '';
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        background-image: url('plus.svg');
    }   
`;
