import { SuggestButtonOptions } from '@src/types';
import { buttonStyle } from './buttonStyle';

interface MAX_WIDTH_FOR_SHORT_TEXT_MAP {
    [index: string]: number
}
interface BUTTON_VIEWS {
    [index: string]: string
}
interface BUTTON_THEMES {
    [index: string]: string
}

const MAX_WIDTH_FOR_SHORT_TEXT_MAP = {
    xs: 204,
    s: 210,
    m: 232,
    l: 238,
    xl: 246,
    xxl: 256,
    default: 232,
} as MAX_WIDTH_FOR_SHORT_TEXT_MAP;
export const BUTTON_VIEWS = {
    main: 'main',
    additional: 'additional',
    default: 'main',
} as BUTTON_VIEWS;
export const BUTTON_THEMES = {
    light: 'light',
    dark: 'dark',
    default: 'light',
} as BUTTON_THEMES;

export const calcCanShowLongText = (size: SuggestButtonOptions['buttonSize'] = 'm', buttonWidth: number): boolean => buttonWidth >= (MAX_WIDTH_FOR_SHORT_TEXT_MAP[size] || MAX_WIDTH_FOR_SHORT_TEXT_MAP.default);

export const setStyle = (): void => {
    const style = document.createElement('style');
    style.id = 'yaPersonalButtonStyle';
    style.innerHTML = buttonStyle;
    document.head.appendChild(style);
};

export const getButtonView = (view: string): string => BUTTON_VIEWS[view] || BUTTON_VIEWS.default;
export const getButtonTheme = (theme: string): string => BUTTON_THEMES[theme] || BUTTON_THEMES.default;

export const removePersonalButtonStub = (): void => {
    const style = document.getElementById('yaPersonalButtonStyle');
    const button = document.getElementById('yaPersonalButton');

    style?.parentNode?.removeChild(style);
    button?.parentNode?.removeChild(button);
};
