import { ActiveProfileContext } from '@common/data/ActiveProfileContext';
import { metrika } from '@common/metrika';
import React, { useCallback, useContext } from 'react';
import { ActiveScreenContext } from '@common/data/ActiveScreenContext';
import { classNames } from '@common/util';
import { EditButton } from '@common/components/ControlButtons/Edit';

import type { UserProfile } from '@src/types';

import styles from './profile.css';

const Contact: React.FC<{ dataT: string }> = ({ dataT, children }) => (
    <div data-t={dataT} className={classNames(styles['profile-contact'], styles['multiline-block'])}>
        {children}
    </div>
);

type ProfileProps = {
    index: number;
    profile: UserProfile;
    onActivate: (index: number) => void;
    isActive?: boolean;
};

export const Profile: React.FC<ProfileProps> = ({ index, isActive, onActivate, profile }) => {
    const { index: activeProfileIndex } = useContext(ActiveProfileContext);
    const { setScreen } = useContext(ActiveScreenContext);

    const onClick = useCallback(() => {
        if (index !== activeProfileIndex) {
            metrika.params({
                selectProfile: {
                    index: String(index + 1),
                },
            });
        }
        onActivate(index);
    }, [index, activeProfileIndex, onActivate]);
    const onEdit = useCallback(() => {
        metrika.params({
            edit: {
                index: String(index + 1),
            },
        });
        setScreen('form');
    }, [index, setScreen]);
    const presetDataT = `preset-${index}`;

    return (
        <div
            data-t={presetDataT}
            className={classNames(styles.profile, isActive && styles.profile_active)}
            onClick={onClick}
        >
            <div className={classNames(styles['profile-username'], styles['multiline-block'])}>
                <span data-t={`${presetDataT}-first-name`}>{profile.firstName}</span>&nbsp;
                <span data-t={`${presetDataT}-last-name`}>{profile.lastName}</span>
            </div>
            {profile.phone && <Contact dataT={`${presetDataT}-phone`}>{profile.phone}</Contact>}
            {profile.email && <Contact dataT={`${presetDataT}-email`}>{profile.email}</Contact>}
            {profile.address && <Contact dataT={`${presetDataT}-address`}>{profile.address}</Contact>}
            <EditButton dataT="preset-edit" className={styles.edit} onClick={onEdit} />
        </div>
    );
};
