import React, { useContext, useState } from 'react';

import { sendMessageToParent } from '@client/util';
import { messages } from '@client/constants';
import { AppDataContext } from '@common/data/AppDataContext';
import { ProviderUser } from '../ProviderUser';
import { ProviderControls } from '../ProviderControls';

import styles from './index.css';
import { classNames } from '@common/util';

const onCloseButtonClick = () => sendMessageToParent({ cause: 'provider', type: messages.close });

const DOCUMENTS = ['national_id', 'international_id', 'driver_license', 'inn', 'snils'];

function getDocumentName(docType: string): string | undefined {
    return {
        national_id: 'Паспорт РФ',
        international_id: 'Загранпаспорт',
        driver_license: 'ВУ',
        inn: 'ИНН',
        snils: 'СНИЛС',
    }[docType];
}

const serviceName: { [key: string]: string } = {
    social: 'Соцсети',
    passport: 'Паспорта',
    plus: 'Плюса',
    cloud: 'Яндекс Облака',
    music: 'Яндекс Музыки',
    money: 'Яндекс Деньги',
    video: 'Яндекс Видео',
    mail: 'Яндкес Почты',
    afisha: 'Яндекс.Афиши',
    market: 'Яндекс Маркета',
    maps: 'Яндекс Карты',
    collections: 'Избранного',
    kp: 'Кинопоиска',
    disk: 'Яндекс Диск',
    beru: 'Беру',
    station: 'Яндекс cтанции',
    'new-plus': 'Яндекс Плюса',
    appmetrika: 'Appmetrica',
    audience: 'Яндекс Аудитории',
    blogs: 'Блогов и клубов Яндекса',
    browser: 'Яндекс Браузера',
    carsharing: 'Яндекс Драйва',
    crypta: 'Поиск и Реклама',
    translate: 'Яндекс Переводчика',
    weather: 'Яндекс Погоды',
    edadeal: 'Едадил',
    games: 'Яндекс Игры',
    forms: 'Яндекс Формы',
    mapsconstructor: 'Конструктора Карт',
    portal: 'Главной страницы',
    praktikum: 'Яндекс Практикума',
    profi: 'Я — профессионал',
    kinopoisk: 'Кинопоиска',
    lavka: 'Лавки',
    metrika: 'Яндекс Метрики',
    deli: 'Yango Deli',
    ugc: 'Мои отзывы',
    uslugi: 'Яндекс Услуг',
    geosmb: 'Яндекс Бизнес',
    sitesearch: 'Яндекс Поиск для сайта',
    mapspano: 'Яндекс Панорамы',
    mapsmrc: 'Приложения Народная карта',
    zen: 'Дзен',
    nmaps: 'Народной Карты',
    messenger: 'Яндекс Мессенджера',
    alisa: 'Алисы',
    q: 'Кью',
    realty: 'Яндекс Недвижимость',
    schoolbook: 'Яндекс Учебник',
    tanker: 'Заправки',
    telemed: 'Здоровье',
    overload: 'Overload',
    taxi: 'Яндекс Такси',
    adfox: 'ADFOX',
    eats: 'Яндекс Еда',
    commentator: 'Комментарии на сервисах Яндекса',
    travelorchestrator: 'Яндекс Путешествия',
    plusstatistic: 'Статистика Плюса',
    xmlsearch: 'Яндекс.XML для ВебМастеров',
    toloka: 'Толоки',
    afishadata: 'Яндекс.Афиша',
};

export const Provider: React.FC = () => {
    const {
        constants: { isDrawer },
        provider: {
            processName,
            docs: { services },
        },
    } = useContext(AppDataContext);

    const [listOpened, setListOpened] = useState(false);

    return (
        <div className={classNames(styles.provider, isDrawer ? styles.providerDrawer : styles.providerModal)}>
            <div className={styles.block}>
                <div className={styles.user}>
                    <ProviderUser />
                </div>
                <div className={styles.title}>
                    {processName === 'save'
                        ? 'Сохранить документ в\xA0Яндекс\xA0ID?'
                        : 'Заполняйте быстрее с\xA0помощью Яндекс\xA0ID'}
                </div>
                <div className={styles.existDoc}>
                    <div className={styles.description}>
                        {processName === 'save'
                            ? 'Сохраним в ID, чтобы вы могли заполнять формы быстрее:'
                            : 'Перенесём в ID и заполним форму данными:'}
                    </div>
                    <div className={styles.documentList}>
                        {services.map(service => (
                            <div key={service.doc_type} className={styles.document}>
                                <div className={classNames(styles.documentIcon, styles[service.doc_type])} />
                                <div className={styles.documentText}>
                                    <div className={styles.documentTitle}>{getDocumentName(service.doc_type)}</div>
                                    <div className={styles.documentDescription}>
                                        {processName === 'save'
                                            ? 'Заполнили только что'
                                            : `из ${serviceName[service.service_name] || service.service_name}`}
                                    </div>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
            <div className={styles.block}>
                <div className={styles.addDoc}>
                    <div className={styles.description}>
                        {'А ещё сохраним в Яндекс ID и другие документы, чтобы использовать их при заполнении форм'}
                    </div>
                    <div className={styles.documentList}>
                        <div
                            className={classNames(styles.listTitle, listOpened && styles['listTitle-opened'])}
                            onClick={() => setListOpened(!listOpened)}
                        >
                            {'Документы, которые будут в ID'}
                        </div>
                        <div className={classNames(styles.documentList, !listOpened && styles['documentList-hidden'])}>
                            {DOCUMENTS.filter(
                                docType => !services.map(service => service.doc_type).includes(docType),
                            ).map(docType => (
                                <div key={docType} className={styles.document}>
                                    <div className={classNames(styles.documentIcon, styles[docType])} />
                                    <div className={styles.documentText}>
                                        <div className={styles.documentTitle}>{getDocumentName(docType)}</div>
                                        <div className={styles.documentDescription}>{'Можно добавить'}</div>
                                    </div>
                                </div>
                            ))}
                        </div>
                    </div>
                </div>
                {!isDrawer && (
                    <div className={styles.controls}>
                        <ProviderControls />
                    </div>
                )}
            </div>
            {isDrawer && (
                <div className={styles.controls}>
                    <div className={styles.block}>
                        <ProviderControls />
                    </div>
                </div>
            )}
            {!isDrawer && (
                <div className={styles.cross} onClick={onCloseButtonClick}>
                    <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M19.2071 6.20711C19.5976 5.81658 19.5976 5.18342 19.2071 4.79289C18.8166 4.40237 18.1834 4.40237 17.7929 4.79289L12 10.5858L6.20711 4.79289C5.81658 4.40237 5.18342 4.40237 4.79289 4.79289C4.40237 5.18342 4.40237 5.81658 4.79289 6.20711L10.5858 12L4.79289 17.7929C4.40237 18.1834 4.40237 18.8166 4.79289 19.2071C5.18342 19.5976 5.81658 19.5976 6.20711 19.2071L12 13.4142L17.7929 19.2071C18.1834 19.5976 18.8166 19.5976 19.2071 19.2071C19.5976 18.8166 19.5976 18.1834 19.2071 17.7929L13.4142 12L19.2071 6.20711Z"
                            fill="#262633"
                        />
                    </svg>
                </div>
            )}
        </div>
    );
};
