import React from 'react';
import { AppDataContext, AppDataContextValue } from '@common/data/AppDataContext';
import { Provider } from './Provider';

import './App.css';
import './ProviderApp.css';

type AppProps = {
    initialData: AppDataContextValue;
};

export const ProviderApp: React.FC<AppProps> = ({ initialData }) => (
    <AppDataContext.Provider value={initialData}>
        <Provider />
    </AppDataContext.Provider>
);
