import { messages } from '@client/constants';
import { sendMessageToParent } from '@client/util';
import { AppDataContext } from '@common/data/AppDataContext';
import React, { useContext, useState } from 'react';
import { BaseActionButton } from '../ActionButtons/BaseActionButton';
import { LoginButton } from '../ActionButtons/LoginButton';

import styles from './index.css';

type Props = {
    isChecked: boolean;
    onChange: (value: boolean) => ANY;
};

export const ProviderCheckbox: React.FC<Props> = ({ isChecked, onChange }) => {
    return (
        <div className={styles.block} onClick={() => onChange(!isChecked)}>
            <div className={styles.checkbox}>
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M0 6C0 2.68629 2.68629 0 6 0H14C17.3137 0 20 2.68629 20 6V14C20 17.3137 17.3137 20 14 20H6C2.68629 20 0 17.3137 0 14V6Z"
                        fill={isChecked ? '#FFDB4D' : '#B4B8CC'}
                        fillOpacity={!isChecked ? '0.26' : undefined}
                    />
                    {isChecked && (
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M16.1306 5.22389C16.5592 5.57215 16.6244 6.20196 16.2761 6.63059L9.77611 14.6306C9.59758 14.8503 9.33427 14.9841 9.05152 14.9987C8.76877 15.0133 8.49309 14.9073 8.29289 14.7071L4.29289 10.7071C3.90237 10.3166 3.90237 9.68342 4.29289 9.29289C4.68342 8.90237 5.31658 8.90237 5.70711 9.29289L8.92308 12.5089L14.7239 5.36941C15.0722 4.94077 15.702 4.87562 16.1306 5.22389Z"
                            fill="#361600"
                        />
                    )}
                </svg>
            </div>
            <div className={styles.label}>Я соглашаюсь на хранение и использование документов в Яндекс ID</div>
        </div>
    );
};
