import { fetch, sendMessageToParent } from '@client/util';
import { messages } from '@client/constants';
import { metrika } from '@common/metrika';
import type { APIBody, Locs } from '@src/types';

export function acceptDocumentsAgreement(locals: Locs): Promise<{ status: 'ok' | 'error', error?: string }> {
    const internalError = locals.errors.internal;

    return new Promise(resolve => {
        fetch<APIBody['acceptDocumentsAgreement']['res'], APIBody['acceptDocumentsAgreement']['req']>(
            '/api/accept-documents-agreement',
            {},
            {
                method: 'POST',
                onSuccess: ({ status, errors }) => {
                    if (status === 'ok') {
                        resolve({ status });
                    } else if (Array.isArray(errors) && errors.length) {
                        metrika.params({ fill: 'accept documents agreement errors' });
                        resolve({ status: 'error', error: errors[0] });
                    } else {
                        metrika.params({ fill: 'accept documents agreement request internal error' });
                        resolve({ status: 'error', error: internalError });
                    }
                },
                onError: (error, statusCode) => {
                    if (statusCode === 401) {
                        sendMessageToParent({
                            cause: 'autofill',
                            type: messages.error,
                            payload: {
                                type: 'user',
                                code: 'no_auth',
                            },
                        });
                        metrika.params({ fill: 'account changed' });
                        sendMessageToParent({ cause: 'autofill', type: messages.denied });
                        resolve({ status: 'error', error: 'unauthorized' });
                    } else {
                        metrika.params({ fill: 'accept documents request internal error' });
                        resolve({ status: 'error', error: internalError });
                    }
                },
            },
        );
    });
}
