import { messages } from '@client/constants';
import { sendMessageToParent } from '@client/util';
import { AppDataContext } from '@common/data/AppDataContext';
import React, { useContext, useState } from 'react';
import { BaseActionButton } from '../ActionButtons/BaseActionButton';
import { LoginButton } from '../ActionButtons/LoginButton';
import { ProviderCheckbox } from '../ProviderCheckbox';
import { acceptDocumentsAgreement } from './acceptDocumentsAgreement';

import styles from './index.css';

const onErrorButtonClick = () =>
    sendMessageToParent({ cause: 'provider', type: messages.error, payload: { type: 'provider', code: 'internal' } });
const onDenyButtonClick = () => sendMessageToParent({ cause: 'provider', type: messages.denied });
const onCloseButtonClick = () => sendMessageToParent({ cause: 'provider', type: messages.close });

export const ProviderControls: React.FC = () => {
    const {
        provider: { processName },
        constants: { isDrawer },
        locals,
    } = useContext(AppDataContext);

    const onAcceptButtonClick = React.useCallback(async () => {
        const result = await acceptDocumentsAgreement(locals);

        if (result.status === 'ok') {
            sendMessageToParent({ cause: 'provider', type: messages.accepted });
        } else if (result.error) {
            sendMessageToParent({ cause: 'provider', type: messages.error });
        }
    }, [locals]);

    const [isCheckboxChecked, onCheckboxCheckChange] = useState(true);

    return (
        <div className={styles.block}>
            <div className={styles.checkbox}>
                <ProviderCheckbox isChecked={isCheckboxChecked} onChange={onCheckboxCheckChange} />
            </div>
            <div className={styles.buttons}>
                <LoginButton
                    disabled={!isCheckboxChecked}
                    className={styles.button}
                    onClick={onAcceptButtonClick}
                    dataT="provider:controls:accept"
                >
                    {processName === 'autofill' ? 'Перенести и заполнить' : 'Сохранить и перенести в ID'}
                </LoginButton>
                {isDrawer && (
                    <BaseActionButton
                        className={styles.button}
                        onClick={onDenyButtonClick}
                        dataT="provider:controls:deny"
                    >
                        {'Спасибо, не надо'}
                    </BaseActionButton>
                )}
            </div>
        </div>
    );
};
