import { AppDataContext } from '@common/data/AppDataContext';
import React, { useContext } from 'react';

import styles from './index.css';

export const ProviderUser: React.FC = () => {
    const {
        provider: { user },
        constants: { avatarTemplate },
    } = useContext(AppDataContext);

    return (
        <div className={styles.block}>
            <div className={styles.id}>
                <svg
                    className={styles.idSvg}
                    width="18"
                    height="18"
                    viewBox="0 0 18 18"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M17.1 8.99904C17.1 13.6658 13.3168 17.449 8.64995 17.449C3.98314 17.449 0.199951 13.6658 0.199951 8.99904C0.199951 4.33224 3.98314 0.549042 8.64995 0.549042C8.02991 0.549042 7.41175 0.617287 6.80664 0.752545L7.19364 2.48389C4.20775 3.14842 1.97543 5.8131 1.97543 8.99917C1.97543 12.6855 4.96377 15.6738 8.65008 15.6738C12.3364 15.6738 15.3247 12.6855 15.3247 8.99917V8.99904H17.1ZM8.64995 0.549042C13.3168 0.549042 17.1 4.33224 17.1 8.99904C17.1 8.379 17.0317 7.76084 16.8964 7.15573L15.1653 7.54268C14.5008 4.55682 11.8361 2.32452 8.65008 2.32452H8.64995V0.549042ZM8.64947 13.9947C10.7055 13.9947 12.4715 12.7527 13.2379 10.9779L11.6109 10.2686C11.1183 11.4163 9.97781 12.2202 8.64961 12.2202C7.33546 12.2202 6.20511 11.4333 5.70415 10.3049L4.07691 11.0143C4.85167 12.7696 6.6075 13.9947 8.64947 13.9947Z"
                        fill="#262633"
                    />
                </svg>
            </div>
            <div
                className={styles.avatar}
                style={{
                    backgroundImage: `url('${avatarTemplate
                        .replace('%avatar_id%', user.avatar)
                        .replace('%size%', '50')}')`,
                }}
            />
            <div className={styles.name}>{user.name}</div>
        </div>
    );
};
