import React from 'react';
import { FillButton } from '@common/components/ActionButtons/FillButton';
import { CardHeader } from '@common/components/CardHeader';

import styles from './skeleton.css';

type RectProps = {
    width: number;
    height: number;
};

const Rect: React.FC<RectProps> = ({ width, height }) => <div style={{ width, height }} className={styles.rect} />;

export const Skeleton: React.FC = () => {
    return (
        <div className={styles.skeleton}>
            <CardHeader />
            <div className={styles.profile}>
                <Rect width={180} height={16} />
                <Rect width={110} height={12} />
                <Rect width={147} height={12} />
                <Rect width={110} height={12} />
            </div>
            <FillButton needValidate={false} disabled />
        </div>
    );
};
