import React from 'react';
import { AppDataContext, AppDataContextValue } from '@common/data/AppDataContext';

import { SuggestCard } from '@common/components/SuggestCard';

import './App.css';
import './SuggestApp.css';

type AppProps = {
    initialData: AppDataContextValue;
};

export const SuggestApp: React.FC<AppProps> = ({ initialData }) => {
    return (
        <AppDataContext.Provider value={initialData}>
            <SuggestCard />
        </AppDataContext.Provider>
    );
};
