import React, { useContext } from 'react';

import { SocialProvider, SuggestUser as SuggestUserType } from '@src/types';
import { classNames } from '@common/util';
import { AppDataContext } from '@common/data/AppDataContext';

import styles from './index.css';

type SuggestUserProps = {
    user: SuggestUserType;
};

export const SuggestUser: React.FC<SuggestUserProps> = ({ user: { avatar, name, defaultEmail, socialProvider } }) => {
    const { constants: { avatarTemplate = '' } = {}, locals } = useContext(AppDataContext);
    const socialProvidersDisplayNames: Record<SocialProvider, string> = {
        vk: locals.social.vkontakte,
        fb: locals.social.facebook,
        gg: locals.social.google,
        mr: locals.social.mailru,
        ok: locals.social.odnoklassniki,
        tw: locals.social.twitter,
    };
    const socialProvidersDisplayName = socialProvider && socialProvidersDisplayNames[socialProvider];

    return (
        <div className={styles.user} data-t="suggest-user">
            <div
                className={classNames(
                    styles.avatar,
                    socialProvidersDisplayName && styles.social,
                    socialProvidersDisplayName && styles[`social_${socialProvider}`],
                )}
                style={{
                    backgroundImage: `url("${avatarTemplate.replace('%avatar_id%', avatar).replace('%size%', '50')}")`,
                }}
                data-t="suggest-user:provider"
            />
            <div className={styles.info} data-t="suggest-user:info">
                <div className={styles.name} data-t="suggest-user:name">
                    {name}
                </div>
                {(socialProvidersDisplayName || defaultEmail) && (
                    <div className={styles.login} data-t="suggest-user:login">
                        {socialProvidersDisplayName || defaultEmail}
                    </div>
                )}
            </div>
        </div>
    );
};
