import React, { createContext, useState, useMemo, useCallback, useContext } from 'react';
import { AppDataContext } from '@common/data/AppDataContext';

import type { UserProfile } from '@src/types';

type ActiveProfileContextValue = {
    index: number;
    setIndex: (index: number) => void;
    profile: UserProfile;
    updateProfile: (profile: UserProfile, force?: boolean) => void;
};
export const ActiveProfileContext = createContext<ActiveProfileContextValue>({
    index: -1,
    setIndex: () => {},
    profile: {},
    updateProfile: () => {},
});

export const ActiveProfileProvider: React.FC = ({ children }) => {
    const { profiles } = useContext(AppDataContext);
    const hasProfiles = Boolean(profiles && profiles.length);

    const [index, setIndex] = useState(hasProfiles ? 0 : -1);
    const [profile, setProfile] = useState<UserProfile>(hasProfiles ? profiles[0] : {});

    const updateProfile = useCallback((newProfile, force = false) => {
        setProfile(currentProfile => ({
            ...(force ? {} : currentProfile),
            ...newProfile,
        }));
    }, []);
    const value = useMemo<ActiveProfileContextValue>(
        () => ({
            index,
            setIndex,
            profile,
            updateProfile,
        }),
        [index, profile, updateProfile],
    );

    return <ActiveProfileContext.Provider value={value}>{children}</ActiveProfileContext.Provider>;
};
