import React, { createContext, useState, useMemo } from 'react';

type ScreenType = 'card' | 'form';

type ActiveScreenContextValue = {
    screen: ScreenType;
    setScreen: (screen: ScreenType) => void;
};

export const ActiveScreenContext = createContext<ActiveScreenContextValue>({
    screen: 'card',
    setScreen: () => {},
});

export const ActiveScreenProvider: React.FC = ({ children }) => {
    const [screen, setScreen] = useState<ScreenType>('card');
    const value = useMemo<ActiveScreenContextValue>(
        () => ({
            screen,
            setScreen,
        }),
        [screen],
    );

    return <ActiveScreenContext.Provider value={value}>{children}</ActiveScreenContext.Provider>;
};
