import { createContext } from 'react';
import { ProviderData, RenderProps, SuggestUser, UserModels, UserProfile } from '@src/types';

export type AppDataContextValue = {
    models: UserModels;
    users: SuggestUser[];
    profiles: UserProfile[];
    locals: RenderProps['locals'];
    meta: RenderProps['meta'];
    initialError: RenderProps['initialErrors'];
    constants: RenderProps['constants'];
    provider: ProviderData;
};

export const AppDataContext = createContext<AppDataContextValue>({
    models: {
        phones: [],
        emails: [],
        addresses: [],
    },
    users: [],
    profiles: [],
    locals: {
        social: {},
        suggest: {},
        common: {},
        extended: {},
        errors: {
            toolong: '',
            required: '',
            internal: '',
            'phone.invalid': '',
            'email.invalid': '',
            'firstName.invalid': '',
            'lastName.invalid': '',
            'address.invalid': '',
            'address.required.city': '',
            'address.required.street': '',
            'address.required.country': '',
            'address.required.building': '',
        },
    },
    meta: {
        whitelist: [],
        targetOrigin: '',
        controlSum: '',
    },
    initialError: {},
    constants: {
        tld: '',
        lang: 'ru',
        metrikaId: '',
        ssrId: '',
        passportAuthUpdateUrl: '',
        passportAuthUrl: '',
        avatarTemplate: '',
        type: 'bro',
        experiments: {},
        theme: 'light',
        suggestView: 'default',
        suggestButtonOptions: {
            buttonSize: 'm',
            buttonView: 'main',
            buttonTheme: 'light',
            buttonBorderRadius: '0',
        },
    },
    provider: {
        processName: 'save',
        user: {
            publicId: '',
            avatar: '',
            name: '',
        },
        docs: [],
    },
});
