import { useLayoutEffect, MutableRefObject } from 'react';
import { addEvent, removeEvent } from '@client/util';

export const useOutsideClick = (refs: MutableRefObject<HTMLElement | null>[], handler: () => void) => {
    useLayoutEffect(() => {
        const listener = (event: MouseEvent) => {
            const needCallHandler = refs.every(
                ref => ref.current && !ref.current.contains(event.target as HTMLElement),
            );

            if (needCallHandler) {
                handler();
            }
        };

        addEvent(document, 'click', listener);

        return () => removeEvent(document, 'click', listener);
    }, [refs, handler]);
};
