import { useState, useEffect } from 'react';
import { isAvailable as isJsApiAvailable, getAppData as getAppDataFromJsApi } from '@client/lib/js-api';
import type { AppDataContextValue } from '@common/data/AppDataContext';

export const useWaitData = (initialData: AppDataContextValue) => {
    const [isLoading, setLoading] = useState(false);
    const [data, setData] = useState<AppDataContextValue>(initialData);

    useEffect(() => {
        if (isJsApiAvailable()) {
            setLoading(true);

            getAppDataFromJsApi().then(userData => {
                setData(data => ({ ...data, ...userData }));
                setLoading(false);
            });
        }
    }, []);

    return { isLoading, data };
};
