import * as csp from 'express-csp-header';
import * as secrets from './secrets.json';

import type { Config } from './types';

const version = '{{VERSION}}';
const yastatic = 'https://yastatic.net/s3/passport-static/autofill';

const common: Pick<Config, 'csp' | 'csrf' | 'version' | 'paths' | 'local' | 'uatraits' | 'avatar'> & {
    geo: Omit<Config['geo'], 'baseUrl'>;
    cloud: Omit<Config['cloud'], 'baseUrl'>;
    passportAPI: Omit<Config['passportAPI'], 'baseUrl' | 'host'>;
    socialAPI: Omit<Config['socialAPI'], 'baseUrl' | 'host' | 'frontendUrl'>;
    documentsAPI: Omit<Config['documentsAPI'], 'baseUrl' | 'host' | 'frontendUrl'>;
} = {
    version,
    local: false,
    csrf: {
        salt: secrets.csrf_salt,
    },
    uatraits: {
        type: 'library',
    },
    paths: {
        assets: `${yastatic}/${version}`,
    },
    avatar: {
        defaultId: '0/0-0',
        url: 'https://avatars.mds.yandex.net/get-yapic/%avatar_id%/islands-%size%',
    },
    cloud: {
        timeout: 8000,
        retry: {
            limit: 5,
            maxRetryAfter: 100,
            statusCodes: [500],
        },
    },
    passportAPI: {
        timeout: 8000,
        retry: {
            limit: 5,
            maxRetryAfter: 100,
            statusCodes: [500],
        },
    },
    socialAPI: {
        timeout: 8000,
        retry: {
            limit: 5,
            maxRetryAfter: 100,
            statusCodes: [500],
        },
    },
    documentsAPI: {
        timeout: 8000,
        retry: {
            limit: 5,
            maxRetryAfter: 100,
            statusCodes: [500],
        },
    },
    geo: {
        type: 'library',
        timeout: 8000,
        origin: 'maps-passport-dev',
    },
    csp: {
        'default-src': [csp.SELF, 'yastatic.net'],
        'manifest-src': [csp.SELF],
        'style-src': [csp.SELF, csp.INLINE, 'yastatic.net'],
        'font-src': [csp.SELF, 'yastatic.net'],
        'img-src': [csp.SELF, csp.DATA, 'mc.admetrica.ru', 'mc.yandex.ru', 'avatars.mds.yandex.net', 'yastatic.net'],
        'child-src': [csp.SELF],
        'frame-src': [csp.SELF, 'mc.yandex.md', 'mc.yandex.ru', 'yandex.ru'],
        'frame-ancestors': [csp.NONE],
        'script-src': [csp.SELF, csp.EVAL, csp.INLINE, csp.NONCE, 'mc.yandex.md', 'mc.yandex.ru', 'yastatic.net'],
        'connect-src': [csp.SELF, 'mc.yandex.ru', 'suggest-maps.yandex.net'],
    },
};

export default common;
