import testing from './testing';

import type { Config } from './types';

const config: Config = {
    ...testing,
    version: 'n/a',
    environment: 'dev',
    cloud: {
        ...testing.cloud,
        https: {
            rejectUnauthorized: false,
        },
    },
    passportAPI: {
        ...testing.passportAPI,
        baseUrl: 'https://passport-test-internal.yandex.ru',
    },
    paths: {
        assets: '/assets',
    },
    geo: {
        ...testing.geo,
        baseUrl: 'http://addrs-testing.search.yandex.net/search/stable',
    },
    oauthUrl: testing.oauthUrl,
};

export default config;
