import development from './development';
import testing from './testing';
import rc from './rc';
import production from './production';
import local from './local';

import type { Config } from './types';

type ConfigName = 'development' | 'testing' | 'production' | 'local' | 'rc';

const configs: Record<ConfigName, Config> = {
    development,
    testing,
    rc,
    production,
    local,
};
const names = Object.keys(configs);
const configEnv = process.env.NODE_CONFIG_ENV || process.env.NODE_ENV;
const config: Config = configs[configEnv && names.includes(configEnv) ? configEnv : 'production'];

export default config;
