import common from './common';

import type { Config } from './types';

const config: Config = {
    ...common,
    environment: 'rc',
    metrika: {
        id: '69331741',
    },
    cloud: {
        ...common.cloud,
        baseUrl: 'https://intapi.disk.yandex.net:8443',
    },
    blackbox: {
        host: 'blackbox-rc.yandex.net',
    },
    geo: {
        ...common.geo,
        baseUrl: 'http://addrs.yandex.ru:17140',
    },
    passport: {
        baseUrl: 'https://passport.yandex.ru',
    },
    passportAPI: {
        ...common.passportAPI,
        baseUrl: 'http://127.0.0.1:6000',
        host: 'passport-internal.yandex.ru',
    },
    socialAPI: {
        ...common.socialAPI,
        baseUrl: 'https://api.social.yandex.ru',
        frontendUrl: 'https://social.yandex.ru',
        host: 'api.social.yandex.ru',
    },
    documentsAPI: {
        ...common.documentsAPI,
        baseUrl: 'https://documents-prod.pers.yandex.net',
        host: 'documents-prod.pers.yandex.net',
    },
    oauthUrl: 'https://oauth-rc.yandex.ru',
};

export default config;
