import type { ExpressCSPParams } from 'express-csp-header';

// type Logger = {
//     pretty?: boolean;
//     level: 'debug' | 'info' | 'warn' | 'error';
// };

export type Config = {
    local: boolean;
    version: string;
    environment: 'dev' | 'prod' | 'stress' | 'testing' | 'rc';
    csp: NonNullable<ExpressCSPParams['directives']>;
    paths: {
        assets: string;
    };
    passport: {
        baseUrl: string;
    };
    passportAPI: {
        host: string;
        baseUrl: string;
        timeout: number;
        https?: {
            rejectUnauthorized: boolean;
        };
        retry?: {
            limit: number;
            statusCodes: number[];
            maxRetryAfter: number;
        };
    };
    socialAPI: {
        host: string;
        baseUrl: string;
        timeout: number;
        frontendUrl: string;
        https?: {
            rejectUnauthorized: boolean;
        };
        retry?: {
            limit: number;
            statusCodes: number[];
            maxRetryAfter: number;
        };
    };
    documentsAPI: {
        host: string;
        baseUrl: string;
        timeout: number;
        https?: {
            rejectUnauthorized: boolean;
        };
        retry?: {
            limit: number;
            statusCodes: number[];
            maxRetryAfter: number;
        };
    };
    avatar: {
        defaultId: string;
        url: string;
    };
    cloud: {
        baseUrl: string;
        timeout: number;
        https?: {
            rejectUnauthorized: boolean;
        };
        retry?: {
            limit: number;
            statusCodes: number[];
            maxRetryAfter: number;
        };
    };
    geo: {
        type: 'http' | 'library';
        origin: string;
        baseUrl: string;
        timeout: number;
    };
    metrika?: {
        id: string;
    };
    uatraits: {
        type: 'http' | 'library';
    };
    blackbox: { host: string };
    oauthUrl: string;
    csrf: {
        salt: string;
    };
};
