import pino from 'pino';
import yandexLogger from '@yandex-int/yandex-logger';
import config from '../config';
import * as tskv from './tskv';

type StreamValue = Record<string, string | string[] | number | Date | undefined | null>;
type MidValue = Record<string, StreamValue[string] | Error>;

export default config.environment === 'dev'
    ? (pino({
          prettyPrint: { colorize: true },
      }) as ANY)
    : yandexLogger({
          middleware: [
              (record: MidValue) => {
                  record.level = record.levelName;
                  record.timestamp = record.date;

                  if (record.err instanceof Error) {
                      record.errorName = record.err.name;
                      record.errorMessage = record.err.message;
                  }

                  ['err', 'pid', 'date', 'msgArgs', 'msgFormat', 'levelName'].forEach(key => {
                      delete record[key];
                  });

                  return record;
              },
          ],
          streams: [
              {
                  level: 'info',
                  stream: {
                      // @ts-ignore
                      write: (record: StreamValue) => process.stdout.write(tskv.format(record) + '\n'),
                  },
              },
          ],
      });
