import type { Request } from 'express';
import type { Theme } from '../../types';

const availableThemes = new Set(['light', 'dark']);

const isAvailableTheme = (theme: string): theme is Theme => {
    return availableThemes.has(theme);
};

export const getTheme = (req: Request): Theme => {
    const { theme } = req.query;

    if (!(typeof theme === 'string') || !isAvailableTheme(theme)) {
        return 'light';
    }

    return theme;
};
