const escape = (() => {
    const replace: Record<string, string> = {
        '\t': '\\t',
        '\n': '\\n',
        '\r': '\\r',
        '\0': '\\0',
        '"': '\\"',
        '\\': '\\\\',
        '=': '\\=',
    };

    return (value: string) =>
        value
            .split('')
            .map(char => replace[char] || char)
            .join('');
})();

// const toUnicode = (value: string) =>
//     value
//         .split('')
//         .map(char => {
//             const hexChar = char.charCodeAt(0).toString(16).toUpperCase();
//
//             if (hexChar.length > 2) {
//                 return '\\u' + hexChar.padStart(4, '0');
//             }
//
//             return char;
//         })
//         .join('');

export const format = (value: Record<string, string | string[] | number | Date | undefined | null>) =>
    Object.entries(value)
        .reduce<string[]>((acc, cur) => {
            const [key] = cur;
            const value = Array.isArray(cur[1]) ? cur[1].join(',') : cur[1];

            if (value || typeof value === 'number') {
                acc.push(`${escape(key)}=${value instanceof Date ? value.getTime() : escape(String(value))}`);
            }

            return acc;
        }, [])
        .join('\t');
