import { RequestHandler } from 'express';
import type { APIBody } from '../../../types';

const acceptDocumentsAgreement: RequestHandler<Record<string, string>, APIBody['acceptDocumentsAgreement']['res'], APIBody['acceptDocumentsAgreement']['req']> = async (req, res)=> {
    try {
        const response = await req.services.passport.acceptDocumentsAgreement();
        const result = response.body;

        if (result.status !== 'ok') {
            return res.json({ status: 'error', errors: result.errors });
        }

        return res.json({ status: 'ok' });
    } catch (error) {
        req.log.error({
            error,
            status: 'error',
        });

        return res.json({ status: 'error' });
    }
};

export {
    acceptDocumentsAgreement,
};
