import type { RequestHandler } from 'express';

const handler: RequestHandler = (req, res, next) => {
    const {
        user,
        misc: { passportAuthUrl, passportAuthUpdateUrl },
    } = req.services;

    return !user.error ? next() : res.redirect(user.error === 'NEED_RESET' ? passportAuthUpdateUrl : passportAuthUrl);
};

export default handler;
