import { expressBlackbox } from '@yandex-int/express-blackbox';
import config from '../config';

import type { RequestHandler } from 'express';

const handlers: RequestHandler[] = [
    expressBlackbox({
        api: config.blackbox.host,
        getServiceTicket: req => req.tvm?.frontend.tickets?.blackbox?.ticket,
        attributes: {
            firstName: '27',
            lastName: '28',
            hasPlus: '1015',
        },
        multisession: 'yes',
        emails: 'getall',
        phones: {
            kind: 'bound',
            attributes: {
                number: '1',
                formatted: '101',
                confirmed: '105',
                secured: '108',
            },
        },
        getYaboxOptions: req => ({
            sessguard: req.cookies.sessguard,
            get_public_id: 'yes',
        }),
    }),
    (req, res, next) => {
        if (req.blackbox?.status === 'VALID' && req.blackbox.userTicket) {
            const { uid, error, status } = req.blackbox;

            req.log.info({
                uid,
                error,
                status: 'ok',
                type: 'blackbox',
                action: 'backend',
                connectionId: req.blackbox.raw.connection_id,
                auth: !uid || error !== 'OK' || status !== 'VALID' ? 0 : 1,
            });
        } else {
            req.log.info({
                status: 'error',
                type: 'blackbox',
                action: 'backend',
                error: req.blackbox?.error,
            });
        }

        return next();
    },
];

export default handlers;
