import type { GeoReply } from './types';

const AVAILABLE_DETAILS_MAPPING: Record<string, 'city' | 'street' | 'country' | 'building'> = {
    COUNTRY: 'country',
    LOCALITY: 'city',
    STREET: 'street',
    HOUSE: 'building',
};
const FALLBACK_MAPPING: Record<string, 'city'> = {
    AREA: 'city',
};

export const parseLocationFromGeoData = (data: GeoReply) => {
    const geoObject = data?.geoObject?.[0];

    if (!geoObject) {
        return null;
    }

    const { name, description } = geoObject;

    if (!name) {
        return null;
    }

    return {
        title: name,
        addressLine: description ? `${description.split(', ').reverse().join(', ')}, ${name}` : name,
        ...(
            geoObject.metadata?.[0]?.['.yandex.maps.proto.search.geocoder.GEO_OBJECT_METADATA'].address.component || []
        ).reduce(
            (acc, cur) => {
                const detailKind = cur.kind?.[0] && AVAILABLE_DETAILS_MAPPING[cur.kind[0]];
                const fallbackKind = cur.kind?.[0] && FALLBACK_MAPPING[cur.kind[0]];

                if (detailKind) {
                    acc[detailKind] = cur.name;
                }

                if (fallbackKind && !acc[fallbackKind]) {
                    acc[fallbackKind] = cur.name;
                }

                return acc;
            },
            {
                city: '',
                street: '',
                country: '',
                building: '',
            },
        ),
    };
};
