import static500 from './static500';

import type { ErrorRequestHandler } from 'express';

export const errorMiddlewareFactory = (type: string): ErrorRequestHandler => (err, req, res, _next) => {
    req.log.error({
        err,
        type,
    });

    return res.status(500).send(static500(req));
};

const handler: ErrorRequestHandler = errorMiddlewareFactory('global-error');

export default handler;
