import type { Request } from 'express';

export default (req: Request) => `
  <!doctype html>
  <html>
    <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
      <title>TODO</title>
      <style type="text/css">
        * {
          margin: 0;
          padding: 0;
          font-family: sans-serif;
        }

        .center {
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: center;
          min-height: 100vh;
          padding: 20px 0;
          box-sizing: border-box;
          text-align: center;
          max-width: 400px;
          margin: 0 auto;
        }

        h1 {
          font-size: 128px;
          color: #e5e5e5;
        }

        .description {
          font-size: 15px;
          margin-top: 32px;
          text-align: center;
        }

        .description b {
          display: inline-block;
        }

        .button {
          background-color: #ffdb4d;
          font-size: 17px;
          font-weight: 500;
          padding: 18px;
          margin-top: 32px;
          cursor: pointer;
        }
      </style>
    </head>
    <body>
      <div class="center">
        <h1>
          500
        </h1>
        <div class="description">
          Ошибка обработки запроса. Код ошибки&nbsp—&nbsp<b>${req.id.slice(
              0,
              8,
          )}</b>.<br>Время&nbsp—&nbsp<b>${new Date().toISOString()}</b>.
        </div>
        <div class="button" id="reload-button">
          Перезагрузить страницу
        </div>
        <script nonce="${req.nonce}">
           document.getElementById('reload-button').addEventListener('click', function () { window.location.reload(); });
        </script>
      </div>
    </body>
  </html>
`;
